<?php

namespace App\Jobs;

use App\Exceptions\OversubscribedFifoLayerException;
use App\Models\FifoLayer;
use App\Models\InventoryMovement;
use App\Models\Warehouse;
use App\Services\InventoryManagement\Actions\FixInvalidFifoLayerFulfilledQuantityCache;
use Exception;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Artisan;
use Symfony\Component\Console\Helper\ProgressBar;

/**
 * @deprecated by FixInvalidFifoLayerFulfilledQuantityCache (called from InvalidFifoLayerFulfilledQuantityCache)
 */
class FixFifoLayerQuantityCacheJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    private array $inventoryMovementsToMove = [];

    protected $bar;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct(protected array $productIds = [])
    {
        //
    }

    /**
     * Execute the job.
     *
     * @throws Exception
     * @throws \Throwable
     */
    public function handle(): array
    {
        return [];
        // Get the fifo layers out of sync (fulfilled quantity doesn't match total inventory movement qty).

        $invalid = [];

        $query = FifoLayer::with([])
            ->whereHas('warehouse', function (Builder $builder) {
                return $builder->where('type', '!=', Warehouse::TYPE_AMAZON_FBA);
            });
        if (! empty($this->productIds)) {
            $query = $query->whereIn('product_id', $this->productIds);
        }

        $this->bar?->start($query->count());

        $fifoLayersNotFixed = [];

        $query->cursor()
            ->each(function (FifoLayer $fifoLayer) use (&$invalid, &$fifoLayersNotFixed) {
                //Log::debug('Fixing fifo layer ' . $fifoLayer->id);
                // We get the active quantity as measured by active movements
                $active = $fifoLayer->inventoryMovements()
                    ->where('inventory_status', InventoryMovement::INVENTORY_STATUS_ACTIVE)
                    ->where('type', '!=', InventoryMovement::TYPE_TRANSFER)
                    ->sum('quantity');

                // We get total quantity in warehouse transfers
                $inWarehouseTransfers = $fifoLayer->inventoryMovements()
                    ->where('type', InventoryMovement::TYPE_TRANSFER)
                    ->sum('quantity');

                // Update the original quantity cache if needed
                $positiveActive = $fifoLayer->inventoryMovements()
                    ->where('inventory_status', InventoryMovement::INVENTORY_STATUS_ACTIVE)
                    ->where('quantity', '>', 0);
                $positiveActiveSum = $positiveActive->sum('quantity');

                // if there is no positive active movement for the FIFO layer, this is a problem, and we need to create one to fix it.
                if ($positiveActiveSum == 0) {
                    app(FixInvalidFifoLayerFulfilledQuantityCache::class)->fix($fifoLayer);
                    $fifoLayer->refresh();
                    $positiveActive = $fifoLayer->inventoryMovements()
                        ->where('inventory_status', InventoryMovement::INVENTORY_STATUS_ACTIVE)
                        ->where('quantity', '>', 0);
                    $positiveActiveSum = $positiveActive->sum('quantity');
                }

                if ($positiveActiveSum != $fifoLayer->original_quantity) {
                    //Log::debug('Updating original quantity cache for FIFO layer: '.$fifoLayer->id.' to '.$positiveActiveSum.' (Fulfilled Qty: '.$fifoLayer->fulfilled_quantity.')');
                    $fifoLayer->original_quantity = $positiveActiveSum;
                    $fifoLayer->save();
                }

                // Quantity available is the sum of what's active and what's in warehouse transfers
                $available = $active + $inWarehouseTransfers;

                // Used quantity as measured by movements
                $usedQuantity = $fifoLayer->original_quantity - $available;

                try {
                    if ($usedQuantity < 0) {
                        // This is a dangerous case, it means the available quantity
                        // is more than the original quantity.
                        throw new Exception('Quantity available exceeds original quantity for FIFO Layer: '.$fifoLayer->id);
                    }

                    if ($usedQuantity != $fifoLayer->fulfilled_quantity) {
                        // The fifo layer fulfilled quantity does not match the used count.
                        $invalid[] = [
                            'id' => $fifoLayer->id,
                            'fulfilled_quantity' => $fifoLayer->fulfilled_quantity,
                            'fulfilled_count' => $usedQuantity,
                        ];

                        // Fix fulfilled quantity
                        $fifoLayer->fulfilled_quantity = $usedQuantity;

                        try {
                            $fifoLayer->save();
                        } catch (OversubscribedFifoLayerException $e) {
                            //                              $this->output->info("FIFO Layer $fifoLayer->id is oversubscribed, attempting to fix.");

                            app(FixInvalidFifoLayerFulfilledQuantityCache::class)->fix($fifoLayer);
                        }
                    }
                } catch (\Throwable $exception) {
                    $fifoLayersNotFixed[] = ['ID' => $fifoLayer->id, 'Error' => $exception->getMessage()];
                }

                $this->bar?->advance();
            });

        // Refresh product inventory
        (new UpdateProductsInventoryAndAvgCost($this->productIds))->handle();
        Artisan::call('sku:release-backorder-queues', ['--products' => $this->productIds]);

        return [$invalid, $fifoLayersNotFixed];
    }

    public function setProgressBar(ProgressBar $bar): static
    {
        $this->bar = $bar;

        return $this;
    }
}
