<?php

namespace App\Jobs;

use App\Models\Product;
use App\Repositories\ProductInventoryRepository;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class DeleteProductInventoryJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    private ProductInventoryRepository $productInventoryRepository;

    public function __construct(private readonly Product $product, private readonly array $exceptWarehouseIds = [])//
    {
        $this->onQueue('syncInventory');
    }

    public function handle(): void
    {
        $this->productInventoryRepository = new ProductInventoryRepository($this->product);
        $this->productInventoryRepository->deleteForProductExceptWarehouseIds($this->exceptWarehouseIds);
    }
}
