<?php

namespace App\Jobs;

use App\Managers\FileManager;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class DeleteOldReportFilesJob implements ShouldBeUnique, ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public int $uniqueFor = 60 * 10;

    public function __construct(private readonly int $days)
    {
    }

    public function handle(): void
    {
        app(FileManager::class)->deleteOldReportFiles($this->days);
    }
}
