<?php

namespace App\Jobs;

use App\Services\FinancialManagement\DailyFinancialManager;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class CalculateDailyFinancialsJob implements ShouldQueue, ShouldBeUnique
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public int $uniqueFor = 60 * 15;

    public function uniqueId(): string
    {
        return 'CalculateDailyFinancialsJob' . md5(serialize($this->days));
    }

    public function __construct(private readonly array $days = [])
    {
        $this->onQueue('financials');
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        (new DailyFinancialManager())->calculate($this->days);
    }
}
