<?php

namespace App\Jobs;

use App\Models\SalesOrder;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class BulkDeleteSalesOrders implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /** @var array */
    protected $request;

    /**
     * Create a new job instance.
     */
    public function __construct(array $request)
    {
        $this->request = $request;
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        set_time_limit(0);

        SalesOrder::with([])
            ->when(isset($this->request['ids']), function ($query) {
                $query->whereIn('id', array_unique($this->request['ids']));
            })
            ->when(! isset($this->request['ids']), function ($query) {
                $query->filter($this->request);
            })
            ->when(isset($this->request['archived']), function ($query) {
                $query->archived($this->request['archived']);
            })
            ->each(function (SalesOrder $salesOrder) {
                $salesOrder->delete();
            });
    }
}
