<?php

namespace App\Jobs;

use App\Integrations\SalesChannelOrder;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class BulkCreateSKUOrdersFromSalesChannelOrders implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /** @var Model */
    protected $model;

    /** @var array */
    protected $request;

    /**
     * Create a new job instance.
     */
    public function __construct(Model $model, array $request)
    {
        $this->model = $model;
        $this->request = $request;
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        set_time_limit(0);

        $this->model::with([])
            ->when(isset($this->request['ids']), function ($query) {
                $query->whereIn((new $this->model)->getKeyName(), $this->request['ids']);
            })
            ->when(! isset($this->request['ids']), function ($query) {
                $query->filter($this->request);
            })
            ->whereNull((new $this->model)->salesOrder()->getForeignKeyName())
            ->each(function ($order) {
                try {
                    /** @var SalesChannelOrder $order */
                    $order->createSKUOrder();
                } catch (\Throwable $e) {
                    $order->errors = [
                        'message' => $e->getMessage(),
                        'file' => $e->getFile(),
                        'line' => $e->getLine(),
                        'code' => $e->getCode(),
                    ];
                    $order->save();
                }
            });
    }
}
