<?php

namespace App\Jobs;

use App\Enums\TrackedJobLogStatusEnum;
use App\Models\Concerns\TrackableJobTrait;
use App\Models\SalesOrder;
use App\Services\SalesOrder\Fulfillments\AutomatedWarehouseFulfillment;
use Illuminate\Contracts\Queue\ShouldQueue;
use Throwable;

class AutomatedSalesOrderFulfillmentJob implements ShouldQueue
{
    use TrackableJobTrait;

    public function __construct(private readonly SalesOrder $salesOrder)
    {
        $this->onQueue('automatedFulfillments');
        $this->initializeTrackedJob($salesOrder, 'Auto Fulfill');
    }

    /**
     * @throws Throwable
     */
    public function handle(): void
    {
        $this->trackProgress(TrackedJobLogStatusEnum::PROCESSING);
        app(AutomatedWarehouseFulfillment::class)->fulfill($this->salesOrder);
        $this->trackProgress(TrackedJobLogStatusEnum::COMPLETED);
    }
}
