<?php

namespace App\Jobs\Accounting;

use App\Repositories\NominalCodeRepository;
use App\Services\Accounting\AccountingTransactionManager;
use Exception;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Throwable;

/**
 * Class SyncAccountingTransactionsJob
 */
class SyncAccountingTransactionsJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    private array $sku_transactions;

    private NominalCodeRepository $nominalCodeRepository;

    protected int $timeout = 600;

    public function uniqueFor(): int
    {
        return 3600; // 1 hour
    }

    public function __construct(array $sku_transactions = [])
    {
        $this->onQueue('accounting');
        $this->sku_transactions = $sku_transactions;
        $this->nominalCodeRepository = app(NominalCodeRepository::class);
    }

    /**
     * @throws Exception
     * @throws Throwable
     */
    public function handle(): void
    {
        if (! $this->nominalCodeRepository->isAccountingNominalCodeMappingsSet()) {
            return;
        }

        $manager = app(AccountingTransactionManager::class);

        $manager->sync($this->sku_transactions);
    }
}
