<?php

namespace App\Integrations\Listings;

use App\Importers\FileImporter;
use App\Models\IntegrationInstance;
use App\Models\TaskStatus\TaskStatus;

abstract class ListingImporter extends FileImporter
{
    /**
     * @var ProductMapper
     */
    protected $mapper;

    /**
     * ListingImporter constructor.
     *
     * @param TaskStatus $task
     * @param $filePath
     * @param IntegrationInstance $integrationInstance
     */
    public function __construct(TaskStatus $task, $filePath, IntegrationInstance $integrationInstance)
    {
        parent::__construct($task, $filePath);
        $modelPath = $integrationInstance->integration->getProductsModelPath();
        $this->mapper = $modelPath::getProductMapper($integrationInstance);
    }
}
