<?php

namespace App\Integrations;

use App\Integrations\Listings\ProductMapper;
use App\Models\IntegrationInstance;

/**
 * Interface Listing.
 */
interface Listing
{
    /**
     * @return mixed
     */
    public function createSkuProduct(array $fieldMapping = []);

    public function getListingUrl(): ?string;

    /**
     * @return mixed
     */
    public static function getResource();

    /**
     * @return mixed
     */
    public static function getProductListingResource();

    public static function getProductMapper(IntegrationInstance $integrationInstance): ProductMapper;

    /**
     * Gets data for csv/excel export.
     */
    public static function makeExportData($builder): array;
}
