<?php

namespace App\Integrations;

interface HasOAuth
{
    /**
     * Generate OAuth user url.
     *
     *
     * @return array
     */
    public function generateOAuthUrl(array $options = []);

    /**
     * Get user access token from code.
     *
     *
     * @return mixed
     */
    public function getAccessToken(string $code = '');

    /**
     * Refresh user access token.
     *
     *
     * @return mixed
     */
    public function refreshAccessToken(string $refresh_token);
}
