<?php

namespace App\Integrations;

use App\Models\SalesChannelType;
use Generator;
use Google_Client;
use Google_Service_ShoppingContent;

class GoogleExpress extends Channel implements HasOAuth
{
    private $google_client;

    private $shopping_content;

    public function __construct($credentials)
    {
        if (array_diff(['client_id', 'client_secret'], array_keys($credentials))) {
            throw new \InvalidArgumentException('client_id and client_secret are required.');
        }

        $this->google_client = new Google_Client();
        //    $client->setApplicationName('Inspire');
        /**
         * set credentials.
         */
        $this->google_client->setClientId($credentials['client_id']);
        $this->google_client->setClientSecret($credentials['client_secret']);
        /**
         * Set redirect uri from config.
         */
        //    $this->google_client->setRedirectUri(config('sales_channels_oauth.google_express.redirect_uri'));
        $this->google_client->setRedirectUri(url(config('sales_channels_oauth.google_express.redirect_uri'), [], true));

        if (! empty($credentials['access_token'])) {
            $this->google_client->setAccessToken($credentials['access_token']);
            $this->shopping_content = new Google_Service_ShoppingContent($this->google_client);
        }
    }

    /**
     * Check sales channel credentials.
     *
     * @return mixed
     */
    public function checkCredentials()
    {
        // TODO: Implement checkCredentials() method.
    }

    /**
     * Generate OAuth user url.
     */
    public function generateOAuthUrl(array $options = []): array
    {
        $state = uniqid(SalesChannelType::TYPE_Google_Express.'_');

        $this->google_client->setScopes(config('sales_channels_oauth.google_express.oauth_scopes'));
        $this->google_client->setState($state);
        $this->google_client->setAccessType('offline');
        $this->google_client->setApprovalPrompt('force');

        return ['state' => $state, 'url' => $this->google_client->createAuthUrl()];
    }

    /**
     * Get user access token from code.
     *
     *
     * @return mixed
     */
    public function getAccessToken(string $code = '')
    {
        return $this->google_client->fetchAccessTokenWithAuthCode(urldecode($code));
    }

    /**
     * Refresh user access token.
     *
     *
     * @return mixed
     */
    public function refreshAccessToken(string $refresh_token)
    {
        return $this->google_client->fetchAccessTokenWithRefreshToken($refresh_token);
    }

    /**
     * Get Orders from sales channel.
     *
     * @param  null  $options
     */
    public function getSalesOrders($options = null): Generator
    {
        $merchant_id = $this->shopping_content->accounts->authinfo()->current()->merchantId;

        $s = new \Google_Service_ShoppingContent_OrdersCreateTestOrderRequest();
        $s->templateName = 'template1';

        return $this->shopping_content->orders->createtestorder($merchant_id, $s);
    }

    /**
     * Get Products from sales channel.
     *
     * @param  null  $options
     */
    public function getProducts($options = null): Generator
    {
        // TODO: Implement getProducts() method.
    }
}
