<?php

namespace App\Importers\Parsers;

/**
 * Class TrimLeft.
 */
class TrimLeft extends Trim
{
    /**
     * @return false|mixed|string
     */
    public function parse($value)
    {
        return substr(
            $value,
            $this->numOfChars
        );
    }

    public function parseSqlQuery(string $column, string $table): string
    {
        $position = $this->numOfChars + 1;

        return "SUBSTR(`$table`.`$column`, $position)";
    }
}
