<?php

namespace App\Importers\Parsers;

class Trim implements FieldParser
{
    /**
     * @var int
     */
    protected $numOfChars;

    public function __construct(array $params)
    {
        if (! isset($params['num_chars'])) {
            throw new \Exception('Must specify num_chars for number of characters.');
        }
        $this->numOfChars = $params['num_chars'];
    }

    public function parse($value)
    {
        return substr(
            $value,
            $this->numOfChars,
            strlen($value) - 2 * $this->numOfChars
        );
    }

    public function parseSqlQuery(string $column, string $table): string
    {
        $position = $this->numOfChars + 1;

        return "SUBSTR(`$table`.`$column`, {$position}, LENGTH(`$table`.`$column`) - 2 * {$this->numOfChars})";
    }
}
