<?php

namespace App\Importers\Parsers;

use Exception;

/**
 * Class FindAndReplace.
 */
class FindAndReplace implements FieldParser
{
    /**
     * @var mixed
     */
    protected $find;

    /**
     * @var mixed
     */
    protected $replace;

    /**
     * FindAndReplace constructor.
     *
     *
     * @throws Exception
     */
    public function __construct(array $params)
    {
        if (! array_key_exists('find', $params) || ! array_key_exists('replace', $params)) {
            throw new Exception('Find and replace values must be provided.');
        }
        $this->find = $params['find'];
        $this->replace = $params['replace'];
    }

    /**
     * @return mixed|string|string[]
     */
    public function parse($value)
    {
        return str_replace($this->find, $this->replace, $value);
    }

    public function parseSqlQuery(string $column, string $table): string
    {
        $find = str_replace("'", "\'", $this->find);
        $replace = str_replace("'", "\'", $this->replace);

        return "REPLACE(`$table`.`$column`, '{$find}', '$replace')";
    }
}
