<?php

namespace App\Importers\Parsers;

use Exception;

class FieldParserFactory
{
    const PARSER_FIND_REPLACE = 'fr';

    const PARSER_TRIM_LEFT = 'tl';

    const PARSER_TRIM_RIGHT = 'tr';

    const PARSER_APPEND = 'append';

    const SUPPORTED_PARSERS = [
        self::PARSER_FIND_REPLACE,
        self::PARSER_TRIM_LEFT,
        self::PARSER_TRIM_RIGHT,
        self::PARSER_APPEND,
    ];

    /**
     * @return FindAndReplace|TrimLeft|TrimRight|Append
     *
     * @throws Exception
     */
    public static function make($rule, array $params, $model)
    {
        if (! in_array($rule, self::SUPPORTED_PARSERS)) {
            throw new Exception("Unsupported field parser: {$rule}");
        }

        switch ($rule) {
            case self::PARSER_FIND_REPLACE:
                return new FindAndReplace($params);
            case self::PARSER_TRIM_LEFT:
                return new TrimLeft($params);
            case self::PARSER_TRIM_RIGHT:
                return new TrimRight($params);
            case self::PARSER_APPEND:
                return new Append($params, $model);
            default:
                throw new Exception("Unknown field parser: {$rule}");
        }
    }
}
