<?php

namespace App\Importers\DataImporters;

use App\DataTable\Exports\DataTableExporter as Exporter;
use App\Importers\DataImporter;

class WarehouseTransferDataImporter extends DataImporter
{
    protected function importRow(array $row)
    {
    }

    public static function getExportableFields()
    {
        return [
            'id' => Exporter::makeExportableField('id', true, 'ID'),
            'warehouse_transfer_number' => Exporter::makeExportableField('warehouse_transfer_number', false),
            'transfer_date' => Exporter::makeExportableField('transfer_date'),
            'from_warehouse.name' => Exporter::makeExportableField('from_warehouse_name'),
            'to_warehouse.name' => Exporter::makeExportableField('to_warehouse_name'),
            'status' => Exporter::makeExportableField('status', false),
            'shipment_status' => Exporter::makeExportableField('shipment_status', false),
            'shipment_percent' => Exporter::makeExportableField('shipment_percent', false),
            'receipt_status' => Exporter::makeExportableField('receipt_status', false),
            'sku' => Exporter::makeExportableField('item_sku'),
            'quantity' => Exporter::makeExportableField('item_quantity'),
            'name' => Exporter::makeExportableField('item_name'),
            'image_url' => Exporter::makeExportableField('item_image_url'),
            'quantity_received' => Exporter::makeExportableField('item_quantity_received', false),
            'origin_available_stock.available' => Exporter::makeExportableField('item_origin_available_stock', false),
            'destination_available_stock.available' => Exporter::makeExportableField('item_destination_available_stock', false),
            'eta' => Exporter::makeExportableField('eta', true),
            'created_at' => Exporter::makeExportableField('created_at', false),
            'updated_at' => Exporter::makeExportableField('updated_at', false),
        ];
    }
}
