<?php

namespace App\Importers\DataImporters;

use App\DataTable\Exports\DataTableExporter;
use App\Importers\DataImporter;
use App\Models\Tag;
use App\Response;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\DB;

class TagDataImporter extends DataImporter
{
    /**
     * @var string[]
     */
    protected $requiredColumns = [
        'name',
    ];

    /**
     * @return mixed|void
     */
    protected function importRow(array $row)
    {
        DB::transaction(function () use ($row) {
            // We create the given tag or update it if possible
            // We attempt to find by id or name
            if (! empty($row['id'])) {
                $tag = Tag::with([])->find($row['id']);
                if (! $tag) {
                    $this->validationErrors[$row['name'] ?? $row['id']] = Response::getError(__('messages.import_export.id_not_exists', ['id' => $row['id']]), Response::CODE_NOT_FOUND, 'id', Arr::only($row, ['id', 'name']));
                    $this->taskStatus->addErrorMessage("Skipping id: The id {$row['id']} doesn't exist in SKU");

                    return;
                }
            } else {
                $tag = Tag::with([])->where('name', $row['name'])->firstOrNew();
            }

            $tag->name = $row['name'];
            $tag->save();
        });
    }

    public static function getExportableFields(): array
    {
        return [
            'id' => DataTableExporter::makeExportableField('id', true, 'ID'),
            'name' => DataTableExporter::makeExportableField('name'),
        ];
    }
}
