<?php

namespace App\Importers\DataImporters;

use App\DataTable\Exports\DataTableExporter as Exporter;
use App\Importers\DataImporter;
use App\Models\NominalCode;
use App\Response;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\DB;

/**
 * Class NominalCodeImporter.
 */
class NominalCodeImporter extends DataImporter
{
    /**
     * @var string[]
     */
    protected $requiredColumns = [
        'name',
        'code',
        'type',
    ];

    /**
     * SupplierDataImporter constructor.
     */
    public function __construct($taskId, string $filePath)
    {
        parent::__construct($taskId, $filePath);
    }

    /**
     * @return mixed|void
     */
    protected function importRow(array $row)
    {
        DB::transaction(function () use ($row) {
            // We create the given nominal code or update it if possible
            // We attempt to find by id or name and type
            if (! empty($row['id'])) {
                $nominalCode = NominalCode::with([])->find($row['id']);
                if (! $nominalCode) {
                    $this->validationErrors[$row['name'] ?? $row['id']] = Response::getError(__('messages.import_export.id_not_exists', ['id' => $row['id']]), Response::CODE_NOT_FOUND, 'id', Arr::only($row, ['id', 'name']));
                    $this->taskStatus->addErrorMessage("Skipping id: The id {$row['id']} doesn't exist in SKU");

                    return;
                }
            } else {
                $nominalCode = NominalCode::with([])->where('name', $row['name'])
                    ->where('type', $row['type'])
                    ->firstOrNew();
            }

            $nominalCode->fill($row)->save();
        });
    }

    public static function getExportableFields(): array
    {
        return [
            'id' => Exporter::makeExportableField('id', true, 'ID'),
            'code' => Exporter::makeExportableField('code'),
            'type' => Exporter::makeExportableField('type'),
            'name' => Exporter::makeExportableField('name'),
        ];
    }
}
