<?php

namespace App\Importers;

use App\Models\User;

/**
 * Class DataImporter.
 */
abstract class DataImporter extends FileImporter
{
    // The maximum size to import synchronously.
    const MAX_SYNCHRONOUS_IMPORT_SIZE = 50;

    protected $expectedColumnsWithLabels = [];

    protected $meta = [];

    protected ?User $user = null;

    /**
     * DataImporter constructor.
     */
    public function __construct($taskId, string $filePath)
    {
        $this->expectedColumns = collect(static::getExportableFields())->map(function ($field) {
            return $field['exported_as'];
        })->values()->toArray();

        parent::__construct($taskId, $filePath);
    }

    public function importableFields(): array
    {
        $fields = collect(static::getExportableFields())->filter(function ($field) {
            return $field['importable'] == true;
        })->toArray();

        return array_values(collect($fields)->map(function ($field) {
            return [
                'key' => $field['exported_as'],
                'value' => $field['label'],
            ];
        })->toArray());
    }

    /**
     * @return $this
     */
    public function setMeta(array $meta = [])
    {
        $this->meta = $meta;

        return $this;
    }

    /**
     * @return int|null
     */
    public function getTaskId()
    {
        return $this->taskStatus->id ?? null;
    }

    protected function beforeImport(): void
    {
    }

    protected function finalizeImport()
    {
    }

    public function sendsImportEmail(): bool
    {
        return false;
    }

    public function setUser(?User $user): self
    {
        $this->user = $user;

        return $this;
    }
}
