<?php

namespace App\Http\Resources;

use App\DataTable\DataTableResource;
use Illuminate\Http\Request;

class WarehouseTransferShipmentResource extends DataTableResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'cost' => $this->inclusive('cost', $this->cost),
            'tracking_number' => $this->inclusive('tracking_number', $this->tracking_number),
            'shipping_method_id' => $this->inclusive('shipping_method_id', $this->shipping_method_id),
            'total_shipped' => $this->inclusive('total_shipped', $this->total_shipped),
            'total_received' => $this->inclusive('total_received', $this->total_received),
        ];
    }
}
