<?php

namespace App\Http\Resources;

use App\Models\WarehouseTransferShipmentReceipt;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

/**
 * Class WarehouseTransferReceiptResource.
 *
 * @mixin WarehouseTransferShipmentReceipt
 */
class WarehouseTransferReceiptResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'received_at' => $this->received_at,
            'user' => [
                'id' => $this->user?->id ?? null,
                'name' => $this->user?->name ?? 'System',
            ],
            'receipt_lines' => $this->whenLoaded('receiptLines', function () {
                return WarehouseTransferReceiptLineResource::collection($this->receiptLines);
            }),
        ];
    }
}
