<?php

namespace App\Http\Resources;

use App\DataTable\DataTableResource;
use App\Models\WarehouseTransferLine;
use Illuminate\Http\Request;

/**
 * Class WarehouseTransferLineResource.
 *
 * @mixin WarehouseTransferLine
 */
class WarehouseTransferLineResource extends DataTableResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        return [
            'quantity' => (float) $this->quantity,
            //'description'                 => $this->description,
            'id' => $this->id,
            'product_id' => $this->product_id,
            'sku' => $this->product?->sku,
            'barcode' => $this->product?->barcode,
            'name' => $this->product?->name ?? $this->description,
            'image_url' => $this->product?->image,
            'quantity_received' => (float) $this->quantity_received,
            'origin_available_stock' => ['available' => $this->warehouseTransfer->fromWarehouse->currentStockLevelForProduct($this->product_id) ?? 0],
            'destination_available_stock' => ['available' => $this->warehouseTransfer->toWarehouse->currentStockLevelForProduct($this->product_id) ?? 0],
            $this->mergeWhen($this->relationLoaded('shipmentLine'), function () {
                $shipmentLine = $this->shipmentLine;
                if ($shipmentLine && $shipmentLine->amazonFbaLedger) {
                    $ledger = $shipmentLine->amazonFbaLedger;
                    $removalShipment = $ledger->details->first();
                    $amazonDetails = [
                        "fnsku" => $ledger->fnsku,
                        "asin" => $ledger->fnsku,
                        "fulfillment_center" => $ledger->fulfillment_center,
                        "disposition" => $ledger->disposition,
                        "carrier" => $removalShipment->carrier,
                        "tracking_number" => $removalShipment->tracking_number
                    ];
                    $shipmentLine = array_merge($shipmentLine->toArray(), ['amazonData' => $amazonDetails]);
                    unset($shipmentLine['amazon_fba_ledger']);
                }
                return [
                    'shipment_line' => $shipmentLine
                ];
            }),
            'has_shipment_line' => $this->shipmentLine !== null,
        ];
    }
}
