<?php

namespace App\Http\Resources;

use App\DataTable\DataTableResource;
use App\Models\User;
use Illuminate\Http\Request;

/**
 * Class UserResource.
 *
 * @mixin User
 */
class UserResource extends DataTableResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'email' => $this->email,
            'email_verified_at' => $this->email_verified_at,
            'activated_at' => $this->activated_at,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
            'deleted_at' => $this->deleted_at,
            'is_admin' => $this->is_admin,
            'is_power_user' => $this->is_power_user,
        ];
    }
}
