<?php

namespace App\Http\Resources;

use App\DataTable\DataTableResource;
use App\Models\TrackedJobLog;

/** @mixin TrackedJobLog */
class TrackedJobLogResource extends DataTableResource
{
    public function toArray($request): array
    {
        return [
            'id' => $this->id,
            'job_type' => $this->inclusive('job_type', $this->job_type),
            'queue' => $this->inclusive('queue', $this->queue),
            'job_name' => $this->inclusive('job_name', $this->job_name),
            'status' => $this->inclusive('status', $this->status),
            'related_model' => $this->inclusive('related_model', [
                'id' => $this->related_model_id,
                'type' => $this->related_model_type,
                'reference' => $this->relatedModel?->getReference(),
            ]),
            'related_model_reference' => $this->inclusive('related_model_reference', $this->relatedModel?->getReference()),
            'messages' => $this->inclusive('messages', $this->messages),
            'attempted_at' => $this->inclusive('attempted_at', $this->attempted_at),
            'completed_at' => $this->inclusive('completed_at', $this->completed_at),
            'duration' => $this->inclusive('duration', $this->duration),
            'created_at' => $this->inclusive('created_at', $this->created_at),
            'updated_at' => $this->inclusive('updated_at', $this->updated_at),
        ];
    }
}
