<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;

class SupplierWarehouseResource extends WarehouseResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        return array_merge(parent::toArray($request), [
            'dropship_enabled' => $this->inclusive('dropship_enabled', $this->dropship_enabled),
            'direct_returns' => $this->inclusive('direct_returns', $this->direct_returns),
            'customer_returns' => $this->inclusive('customer_returns', $this->customer_returns),
        ]);
    }
}
