<?php

namespace App\Http\Resources;

use App\DataTable\DataTableResource;
use App\Models\Supplier;
use Illuminate\Http\Request;

/**
 * Class SupplierResource.
 *
 * @mixin Supplier
 */
class SupplierResource extends DataTableResource
{
    /**
     * @var Supplier
     */
    public $resource = null;

    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        return [
            'name' => $this->inclusive('name', $this->name),
            'id' => $this->id,
            'company_name' => $this->inclusive('company_name', $this->company_name),
            'company' => $this->inclusive('company_name', $this->company_name),
            'email' => $this->inclusive('email', $this->email),
            'primary_contact_name' => $this->inclusive('primary_contact_name', $this->primary_contact_name),
            'purchase_order_email' => $this->inclusive('purchase_order_email', $this->purchase_order_email),
            'website' => $this->inclusive('website', $this->website),
            'leadtime' => $this->inclusive('leadtime', $this->leadtime),
            'minimum_order_quantity' => $this->inclusive('minimum_order_quantity', $this->minimum_order_quantity),
            'minimum_purchase_order' => $this->inclusive('minimum_purchase_order', $this->minimum_purchase_order),
            'purchase_order_format' => $this->inclusive('purchase_order_format', $this->purchase_order_format),
            'created_at' => $this->inclusive('created_at', $this->created_at),
            'updated_at' => $this->inclusive('updated_at', $this->updated_at),
            'archived_at' => $this->inclusive('archived_at', $this->archived_at),
            'address' => $this->inclusive('address', [
                'id' => $this->inclusive('address_id', $this->default_address->id ?? null),
                'label' => $this->inclusive('label', $this->default_address->label ?? null),
                'name' => $this->inclusive('name', $this->default_address->name ?? null),
                'phone' => $this->inclusive('phone', $this->default_address->phone ?? null),
                'company' => $this->inclusive('company', $this->default_address->company ?? null),
                'address1' => $this->inclusive('address1', $this->default_address->address1 ?? null),
                'address2' => $this->inclusive('address2', $this->default_address->address2 ?? null),
                'address3' => $this->inclusive('address3', $this->default_address->address3 ?? null),
                'city' => $this->inclusive('city', $this->default_address->city ?? null),
                'province' => $this->inclusive('province', $this->default_address->province ?? null),
                'province_code' => $this->inclusive('province_code', $this->default_address->province_code ?? null),
                'zip' => $this->inclusive('zip', $this->default_address->zip ?? null),
                'country' => $this->inclusive('country', $this->default_address->country ?? null),
                'country_code' => $this->inclusive('country_code', $this->default_address->country_code ?? null),
                'fax' => $this->inclusive('fax', $this->default_address->fax ?? null),
            ]),
            'label' => $this->inclusive('label', $this->default_address->label ?? null),
            'phone' => $this->inclusive('phone', $this->default_address->phone ?? null),
            //      'company'                => $this->inclusive( 'company', $this->default_address->company ?? null ),
            'address1' => $this->inclusive('address1', $this->default_address->address1 ?? null),
            'address2' => $this->inclusive('address2', $this->default_address->address2 ?? null),
            'address3' => $this->inclusive('address3', $this->default_address->address3 ?? null),
            'city' => $this->inclusive('city', $this->default_address->city ?? null),
            'province' => $this->inclusive('province', $this->default_address->province ?? null),
            'province_code' => $this->inclusive('province_code', $this->default_address->province_code ?? null),
            'zip' => $this->inclusive('zip', $this->default_address->zip ?? null),
            'country' => $this->inclusive('country', $this->default_address->country ?? null),
            'country_code' => $this->inclusive('country_code', $this->default_address->country_code ?? null),
            'fax' => $this->inclusive('fax', $this->default_address->fax ?? null),
            'pricing' => $this->inclusive('pricing', function () {
                return $this->whenLoaded('pricingTiers', SupplierPricingTierResource::collection($this->pricingTiers));
            }),
            'warehouses' => $this->whenLoaded('warehouses', function () {
                return SupplierWarehouseResource::collection($this->warehouses);
            }),
            'default_pricing_tier' => $this->inclusive('default_pricing_tier', $this->defaultPricingTier ? [
                'id' => $this->defaultPricingTier->id,
                'name' => $this->defaultPricingTier->name,
                'currency_code' => $this->defaultPricingTier->currency_code,
            ] : null),
            'default_warehouse_id' => $this->inclusive('default_warehouse_id', $this->default_warehouse_id),
            'default_store_id' => $this->inclusive('default_store_id', $this->default_store_id),
            'default_store' => $this->inclusive('defaultStore', $this->whenLoaded('defaultStore', function () {
                return StoreResource::make($this->defaultStore);
            })),
            'po_processing_method' => $this->inclusive('po_processing_method', $this->po_processing_method),
            'po_batch_schedule' => $this->inclusive('po_batch_schedule', $this->po_batch_schedule),
            'default_shipping_method' => $this->inclusive('default_shipping_method', $this->defaultShippingMethod),
            'auto_fulfill_dropship' => $this->inclusive('auto_fulfill_dropship', $this->auto_fulfill_dropship),
            'auto_submit_dropship_po' => $this->inclusive('auto_submit_purchase_orders', $this->auto_submit_dropship_po),
            'auto_generate_backorder_po' => $this->inclusive('auto_generate_backorder_po', $this->auto_generate_backorder_po),
            'auto_submit_backorder_po' => $this->inclusive('auto_submit_backorder_po', $this->auto_submit_backorder_po),
            'auto_split_backorder_po_by_brand' => $this->inclusive('auto_split_backorder_po_by_brand', $this->auto_split_backorder_po_by_brand),
            'auto_receive_backorder_po' => $this->inclusive('auto_receive_backorder_po', $this->auto_receive_backorder_po),
            'backorder_po_schedule' => $this->inclusive('backorder_po_schedule', $this->backorder_po_schedule),
            'default_stock_level' => $this->inclusive('default_stock_level', $this->default_stock_level),
            'default_tax_rate_id' => $this->inclusive('default_tax_rate_id', $this->default_tax_rate_id),
            'timezone' => $this->inclusive('timezone', $this->timezone),
        ];
    }
}
