<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class SupplierProductResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'product_id' => $this->product_id,
            'supplier_id' => $this->supplier_id,
            'supplier_sku' => $this->supplier_sku,
            'leadtime' => $this->leadtime,
            'minimum_order_quantity' => $this->minimum_order_quantity,
            'is_default' => $this->is_default,
            'default_tax_rate_id' => $this->default_tax_rate_id,
            'supplier' => $this->whenLoaded('supplier'),
            'supplier_default_tax_rate_id' => $this->supplier ? $this->supplier->default_tax_rate_id : null,

            'product' => $this->whenLoaded('product', function () use ($request) {
                $this->product->load('productPricingTiers', 'totalInventory', 'parent');

                return array_merge(ProductResource::make($this->product)->toArray($request), [
                    'leadtime' => $this->product_leadtime,
                ]);
            }),
            'supplier_stock' => $this->whenLoaded('product', function () {
                return $this->product->suppliersInventory ? $this->product->suppliersInventory->firstWhere('supplier_id', $this->supplier_id) : 0;
            }),
            'pricing' => SupplierProductPricingResource::collection($this->whenLoaded('supplierPricingTiers')),
        ];
    }
}
