<?php

namespace App\Http\Resources;

use App\DataTable\DataTableResource;
use App\Models\SupplierPricingTier;
use Illuminate\Http\Request;

/**
 * @mixin SupplierPricingTier
 */
class SupplierPricingTierResource extends DataTableResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'name' => $this->inclusive('name', $this->name),
            'currency_code' => $this->inclusive('currency_code', $this->currency_code),
            'is_default' => $this->inclusive('is_default', $this->is_default),
            'created_at' => $this->inclusive('created_at', $this->created_at),
            'updated_at' => $this->inclusive('updated_at', $this->updated_at),
            'archived_at' => $this->inclusive('archived_at', $this->archived_at),
        ];
    }
}
