<?php

namespace App\Http\Resources;

use App\DataTable\DataTableResource;
use App\Models\Store;
use Illuminate\Http\Request;

/**
 * Class StoreResource.
 *
 *
 * @mixin Store
 */
class StoreResource extends DataTableResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        return [
            'name' => $this->inclusive('name', $this->name),
            'id' => $this->id,
            'logo_url' => $this->inclusive('logo_url', $this->logo_url),
            'custom_jrxml_file' => $this->inclusive('custom_jrxml_file', $this->custom_jrxml_file),
            'custom_message' => $this->inclusive('custom_message', $this->custom_message),
            'company' => $this->inclusive('company', $this->company_name),
            'company_name' => $this->inclusive('company', $this->company_name),
            'email' => $this->inclusive('email', $this->email),
            'po_email' => $this->inclusive('po_email', $this->po_email),
            'archived_at' => $this->inclusive('archived_at', $this->archived_at),
            'created_at' => $this->inclusive('created_at', $this->created_at),
            'updated_at' => $this->inclusive('updated_at', $this->updated_at),
            'sales_channels' => $this->whenLoaded('salesChannels', function () {
                return $this->salesChannels->map->only('id', 'name');
            }),

            $this->mergeWhen($this->whenLoaded('address', true, false) !== false, function () {
                return [
                    'phone' => $this->inclusive('phone', $this->address->phone ?? null),
                    'fax' => $this->inclusive('fax', $this->address->fax ?? null),
                    'address1' => $this->inclusive('address1', $this->address->address1 ?? null),
                    'address2' => $this->inclusive('address2', $this->address->address2 ?? null),
                    'address3' => $this->inclusive('address3', $this->address->address3 ?? null),
                    'city' => $this->inclusive('city', $this->address->city ?? null),
                    'province' => $this->inclusive('province', $this->address->province ?? null),
                    'province_code' => $this->inclusive('province_code', $this->address->province_code ?? null),
                    'zip' => $this->inclusive('zip', $this->address->zip ?? null),
                    'country' => $this->inclusive('country', $this->address->country ?? null),
                    'country_code' => $this->inclusive('country_code', $this->address->country_code ?? null),
                ];
            }),
        ];
    }
}
