<?php

namespace App\Http\Resources;

use App\DataTable\DataTableResource;
use App\Models\StoreEmailTemplate;
use Illuminate\Http\Request;

/**
 * Class StoreEmailTemplateResource.
 *
 * @mixin StoreEmailTemplate
 */
class StoreEmailTemplateResource extends DataTableResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'store_id' => $this->store_id,
            'store' => $this->inclusive('store', $this->whenLoaded('store', function () {
                return $this->store->only('id', 'name');
            })),
            'type' => $this->type,
            'subject' => $this->subject,
            'title' => $this->subject,
            'enabled' => $this->enabled,
            'attach_pdf' => $this->attach_pdf,
            'sent_type' => $this->sent_type,
            'html_body' => $this->inclusive('html_body', $this->html_body),
            'is_system_template' => $this->is_system_template,
            'cc' => $this->cc,
            'archived_at' => $this->archived_at,
            'updated_at' => $this->updated_at,
            'created_at' => $this->created_at,
        ];
    }
}
