<?php

namespace App\Http\Resources;

use App\DataTable\DataTableResource;
use App\StockTake;
use Illuminate\Http\Request;

/**
 * Class StockTakeResource.
 *
 * @mixin StockTake
 */
class StockTakeResource extends DataTableResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        $this->loadMissing('warehouse', 'stockTakeItems');

        return [
            'id' => $this->id,
            'date_count' => $this->inclusive('date_count', $this->date_count),
            'is_initial_count' => $this->inclusive('is_initial_count', $this->is_initial_count),
            'warehouse' => $this->whenLoaded('warehouse', function () {
                return [
                    'id' => $this->warehouse_id,
                    'name' => $this->warehouse->name ?? null,
                ];
            }),
            'status' => $this->inclusive('status', $this->status),
            'value_change' => $this->inclusive('value_change', $this->value_change),
            'notes' => $this->inclusive('notes', $this->notes),
            'created_at' => $this->inclusive('created_at', $this->created_at),
            'updated_at' => $this->inclusive('updated_at', $this->updated_at),
            'archived_at' => $this->inclusive('archived_at', $this->archived_at),
            'items' => $this->inclusive('items', $this->whenLoaded('stockTakeItems', function () {
                $this->stockTakeItems->map->setRelation('stockTake', $this->resource);

                return StockTakeItemResource::collection($this->stockTakeItems);
            })),
        ];
    }
}
