<?php

namespace App\Http\Resources;

use App\DataTable\DataTableResource;
use App\Models\StockTakeItem;
use Illuminate\Http\Request;

/**
 * Class StockTakeItemResource.
 *
 * @mixin StockTakeItem
 */
class StockTakeItemResource extends DataTableResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->when($this->id, $this->id),
            'qty_counted' => $this->inclusive('qty_counted', $this->qty_counted),
            'item_sku' => $this->inclusive('item_sku', $this->product->sku),
            'item_barcode' => $this->inclusive('item_barcode', $this->product->barcode),
            'item_product_id' => $this->inclusive('item_product_id', $this->product->id),
            'item_name' => $this->inclusive('item_name', $this->product->name),
            'item_unit_cost' => $this->unit_cost,
            'image_url' => $this->inclusive('image_url', $this->product->image),
            'snapshot_inventory' => $this->inclusive('snapshot_inventory', $this->snapshot_inventory ?? 0),
        ];
    }
}
