<?php

namespace App\Http\Resources;

use App\Models\ShippingProviderWarehouseMapping;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

/**
 * @mixin ShippingProviderWarehouseMapping
 */
class ShipstationWarehouseMappingResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'warehouse' => $this->whenLoaded('warehouse', function(){
                return WarehouseResource::make($this->warehouse);
            }),
            'shipstation_warehouse' => $this->whenLoaded('provider', function(){
                return [
                    'id' => $this->provider->shipstation_id,
                    'name' => $this->provider->name,
                    'is_default' => $this->provider->is_default,
                    'json_object' => $this->provider->json_object
                ];
            }),
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at
        ];
    }
}
