<?php

namespace App\Http\Resources\Shipstation;

use App\DataTable\DataTableResource;
use App\Models\ShipStation\ShippingService;
use Illuminate\Http\Request;

/**
 * Class ShipStationShippingServiceResource.
 *
 *
 * @mixin ShippingService
 */
class ShippingServiceResource extends DataTableResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->_id,
            'name' => $this->name,
            'carrier_code' => $this->carrierCode,
            'carrier_name' => $this->carrierName,
            'carrier_nickname' => $this->carrierNickname,
            'code' => $this->code,
            'domestic' => $this->domestic,
            'integration_instance_id' => $this->integration_instance_id,
            'international' => $this->international,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
            // mapped shipping method
            'shipping_method_id' => $this->integration_shipping_method->shipping_method_id ?? null,
        ];
    }
}
