<?php

namespace App\Http\Resources;

use App\DataTable\DataTableResource;
use App\Models\ShippingMethodMappingsSalesChannelToSku;
use Illuminate\Http\Request;

/**
 * @mixin ShippingMethodMappingsSalesChannelToSku
 */
class ShippingMethodMappingSalesChannelResource extends DataTableResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'sales_channel_id' => $this->sales_channel_id,
            'sales_channel_method' => $this->sales_channel_method,
            'shipping_method_id' => $this->shipping_method_id,
            'shipping_method_name' => $this->shippingMethod->name ?? null,
        ];
    }
}
