<?php

namespace App\Http\Resources;

use App\Models\SalesOrderLineFinancial;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

/**
 * Class SalesOrderLineProformaFinancialResource.
 *
 * @mixin SalesOrderLineFinancial
 */
class SalesOrderLineProformaFinancialResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        $salesOrderLine = $this->salesOrderLine;

        return [
            'product' => $this->when($salesOrderLine->is_product, function () use ($salesOrderLine) {
                $product = $salesOrderLine->product;

                return [
                    'id' => $product?->id,
                    'sku' => $product?->sku,
                    'name' => $product?->name,
                ];
            }),
            'description' => $salesOrderLine->description,
            'quantity' => $salesOrderLine->quantity,
            'price' => $salesOrderLine->amount_in_tenant_currency,
            'tax_allocation' => $salesOrderLine->tax_allocation_in_tenant_currency,
            'tax_rate_id' => $salesOrderLine->tax_allocation_in_tenant_currency,
            'revenue' => $this->revenue,
            'revenue_allocated' => $this->revenue_allocated,
            'credits' => $this->credits,
            'total_revenue' => $this->total_revenue,
            'cogs' => $this->cogs,
            'cost_allocated' => $this->cost_allocated,
            'cogs_returned' => $this->cogs_returned,
            'total_cost' => $this->total_cost,
            'profit' => $this->profit,
            'profit_margin' => $this->profit_margin,
            'per_unit.revenue' => round($this->perUnit('revenue'), 2),
            'per_unit.revenue_allocated' => round($this->perUnit('revenue_allocated'), 2),
            'per_unit.credits' => round($this->perUnit('credits'), 2),
            'per_unit.total_revenue' => round($this->perUnit('total_revenue'), 2),
            'per_unit.cogs' => round($this->perUnit('cogs'), 2),
            'per_unit.cost_allocated' => round($this->perUnit('cost_allocated'), 2),
            'per_unit.cogs_returned' => round($this->perUnit('cogs_returned'), 2),
            'per_unit.total_cost' => round($this->perUnit('total_cost'), 2),
            'per_unit.profit' => round($this->perUnit('profit'), 2),
        ];
    }
}
