<?php

namespace App\Http\Resources;

use App\Models\SalesOrderFulfillmentLine;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

/**
 * Class SalesOrderFulfillmentLineResource.
 *
 * @mixin SalesOrderFulfillmentLine
 */
class SalesOrderFulfillmentLineResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'sales_order_line_id' => $this->sales_order_line_id,
            'sales_order_fulfillment_id' => $this->sales_order_fulfillment_id,
            'quantity' => $this->quantity,
            'unit_cost' => $this->salesOrderLine->salesOrderLineFinancial?->cogs ?? 00,
            'metadata' => $this->metadata,
            'item_inventory' => SalesOrderLineInventoryResource::make($this->salesOrderLine->product),
        ];
    }
}
