<?php

namespace App\Http\Resources;

use App\Models\SalesOrder;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

/**
 * Class SalesOrderFinancialResource.
 *
 * @mixin SalesOrder
 */
class SalesOrderFinancialResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'sales_order_lines' => SalesOrderLineProformaFinancialResource::collection(
                $this->salesOrderLineFinancials
            ),
            'is_tax_included' => $this->is_tax_included,
            /*
             * We are disabling the following lines from the resource since we do not have a good design
             * for how users can update these manual estimates.  We'll instead rely solely on calculated
             * estimates that get cached in the sales order lines for now
             */
            // cached from currency at time of sale
            'currency' => $this->currency->code,
            // cached rate from sale currency to default currency at time of sale
            'currency_rate' => $this->currency_rate,
        ];
    }
}
