<?php

namespace App\Http\Resources;

use App\Models\SalesCreditReturnLine;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

/**
 * Class SalesCreditReturnLineResource.
 *
 *
 * @mixin SalesCreditReturnLine
 */
class SalesCreditReturnLineResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'received_at' => $this->salesCreditReturn->received_at,
            'quantity' => $this->quantity,
            'action' => $this->action,
            'reason_id' => $this->reason_id,
            'reason' => $this->returnReason->name,
            'notes' => $this->notes,
        ];
    }
}
