<?php

namespace App\Http\Resources;

use App\DataTable\DataTableResource;
use Illuminate\Http\Request;

class SalesChannelResource extends DataTableResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'name' => $this->inclusive('name', $this->name),
            'sales_channel_type_id' => $this->sales_channel_type_id,
            'sales_channel_type' => $this->inclusive('sales_channel_type', $this->type->name ?? null),
            'sales_channel_type_image' => $this->inclusive('sales_channel_type_image', $this->type->image_url ?? null),
            'country' => $this->inclusive('country', $this->country),
            'store' => $this->inclusive('store', $this->store->name ?? null),
            'store_id' => $this->store_id,
            'created_at' => $this->inclusive('created_at', $this->created_at),
            'updated_at' => $this->inclusive('updated_at', $this->updated_at),

            $this->mergeWhen(! auth('basic')->check(), function () {
                return [
                    'connection_settings' => $this->connection_settings,
                    'integration_settings' => $this->integration_settings,
                ];
            }),
        ];
    }
}
