<?php

namespace App\Http\Resources;

use App\DataTable\DataTableResource;
use App\Models\ReportingDailyProductAccountingFinancials;
use Illuminate\Http\Request;

/**
 * Class ReportingProductMostProfitableResource.
 *
 * @mixin ReportingDailyProductAccountingFinancials
 */
class ReportingProductMostProfitableResource extends DataTableResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        return [
            'product' => $this->whenLoaded('product', function () {
                return [
                    'id' => $this->product->id,
                    'name' => $this->product->name,
                    'sku' => $this->product->sku,
                    'image_url' => $this->product->image,
                    'brand' => $this->when($this->product->brand, function () {
                        return [
                            'id' => $this->product->brand_id,
                            'name' => $this->product->brand->name,
                        ];
                    }),
                ];
            }),
            'quantity_sold' => $this->inclusive('quantity_sold', $this->quantity),
            'net_profit' => $this->inclusive('net_profit', $this->net_profit),
        ];
    }
}
