<?php

namespace App\Http\Resources;

use App\DataTable\DataTableResource;
use App\Models\Product;
use App\Models\ReportingDailyFinancial;
use Illuminate\Http\Request;

/**
 * Class ReportingProductFinancials.
 *
 * @mixin ReportingDailyFinancial
 */
class ReportingProductFinancials extends DataTableResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        /** @var Product $product */
        $product = $this->getModel()->product;

        return [
            'product' => $this->whenLoaded('product', function () use ($product) {
                return [
                    'id' => $product->id,
                    'name' => $product->name,
                    'sku' => $product->sku,
                    'image_url' => $product->image,
                    'brand' => $this->when($product->brand, function () use ($product) {
                        return [
                            'id' => $product->brand_id,
                            'name' => $product->brand->name,
                        ];
                    }),
                ];
            }),
            'quantity_sold' => $this->inclusive('quantity_sold', $this->quantity),
            'revenue' => $this->inclusive('revenue', $this->revenue),
            'costs' => $this->inclusive('costs', $this->costs),
            'net_profit' => $this->inclusive('profit', $this->profit),
            'num_orders' => $this->inclusive('num_orders', $this->num_orders),
        ];
    }
}
