<?php

namespace App\Http\Resources;

use App\DataTable\DataTableResource;
use App\Models\FinancialLineType;
use App\Models\Product;
use App\Models\ReportingDailyFinancial;
use Illuminate\Http\Request;

/**
 * Class ReportingDailyFinancialResource.
 *
 * @mixin ReportingDailyFinancial
 */
class ReportingDailyFinancialResource extends DataTableResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->inclusive('id', $this->id),
            'date' => $this->inclusive('date', $this->date),
            'reportable' => $this->inclusive('reportable', function () {
                $data = [
                    'id' => $this->reportable_id,
                    'type' => $this->reportable_type,
                ];
                switch ($this->reportable_type) {
                    case Product::class:
                        /** @var Product $product */
                        $product = $this->product;
                        $data['product'] = [
                            'id' => $product->id,
                            'sku' => $product->sku,
                            'brand' => $product->brand?->name,
                        ];
                        break;
                    case FinancialLineType::class:
                        /** @var FinancialLineType $financialLineType */
                        $financialLineType = $this->reportable;
                        $data['financial_line_type'] = [
                            'id' => $financialLineType->id,
                            'name' => $financialLineType->name,
                            'classification' => $financialLineType->classification,
                        ];
                        break;
                }

                return $data;
            }),
            'quantity' => $this->inclusive('quantity', $this->quantity),
            'num_orders' => $this->inclusive('num_orders', $this->num_orders),
            'revenue' => $this->inclusive('revenue', $this->revenue),
            'revenue_allocated' => $this->inclusive('revenue_allocated', $this->revenue_allocated),
            'revenue_credits' => $this->inclusive('revenue_credits', $this->revenue_credits),
            'total_revenue' => $this->inclusive('total_revenue', $this->total_revenue),
            'cost' => $this->inclusive('cost', $this->cost),
            'cost_allocated' => $this->inclusive('cost_allocated', $this->cost_allocated),
            'cost_invoices' => $this->inclusive('cost_invoices', $this->cost_invoices),
            'cost_returned' => $this->inclusive('cost_returned', $this->cost_returned),
            'total_cost' => $this->inclusive('total_cost', $this->total_cost),
            'profit' => $this->inclusive('profit', $this->profit),
            'profit_margin' => $this->inclusive('profit_margin', $this->profit_margin),
            'updated_at' => $this->inclusive('updated_at', $this->updated_at),
            'created_at' => $this->inclusive('created_at', $this->created_at),
        ];
    }
}
