<?php

namespace App\Http\Resources;

use App\Models\PurchaseOrderShipmentReceipt;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

/**
 * Class PurchaseOrderReceiptResource.
 *
 * @mixin PurchaseOrderShipmentReceipt
 */
class PurchaseOrderReceiptResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        $this->load('purchaseOrderShipmentReceiptLines', 'user');

        return [
            'id' => $this->id,
            'received_at' => $this->received_at,
            'fulfilled_by' => $this->whenLoaded('user', function () {
                return [
                    'id' => $this->user->id,
                    'name' => $this->user->name,
                ];
            }),
            // receipt lines
            'purchase_order_shipment_receipt_lines' => PurchaseOrderReceiptLineResource::collection($this->purchaseOrderShipmentReceiptLines),
        ];
    }
}
