<?php

namespace App\Http\Resources;

use App\Services\PurchaseOrder\PurchaseOrderBuilder\PurchaseOrderBuilderLine;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

/**
 * Class PurchaseOrderBuilderLineResource.
 *
 * @mixin PurchaseOrderBuilderLine
 */
class PurchaseOrderBuilderLineResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        $this->getSupplierProduct()->loadMissing(['product', 'product.productInventory', 'supplierPricingTiers']);

        return [
            'quantity' => $this->getQuantity(),
            'sales_order_line' => $this->when($this->getSalesOrderLineId(), function () {
                return [
                    'id' => $this->getSalesOrderLineId(),
                    'sales_order_id' => $this->getSalesOrderId(),
                    'sales_order_number' => $this->getSalesOrderNumber(),
                    'quantity' => $this->getQuantity(),
                    'backorder_queue_id' => $this->getBackorderQueueId(),
                ];
            }),
            'calculation' => $this->getCalculation(),
            'inventory' => POBuilderSalesOrderLineInventoryResource::make($this->getSupplierProduct()->product),
            'supplier_product' => POBuilderSupplierProductResource::make($this->getSupplierProduct()),
        ];
    }
}
