<?php

namespace App\Http\Resources;

use App\Models\PurchaseInvoice;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

/**
 * Class PurchaseInvoiceResource.
 *
 * @mixin PurchaseInvoice
 */
class PurchaseInvoiceResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'purchase_order_id' => $this->purchase_order_id,
            'supplier_invoice_number' => $this->supplier_invoice_number,
            'supplier_id' => $this->supplier_id,
            'supplier_name' => $this->supplier->name,
            'status' => $this->status,
            'purchase_invoice_lines' => $this->whenLoaded('purchaseInvoiceLines', function () {
                return PurchaseInvoiceLineResource::collection($this->purchaseInvoiceLines);
            }),
            'purchase_invoice_date' => $this->purchase_invoice_date,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}
