<?php

namespace App\Http\Resources;

use App\Models\Product;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

/**
 * Class ProductSupplierStockResource.
 *
 * @mixin Product
 */
class ProductSupplierStockResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        $supplierStock = $this->suppliersInventory->firstWhere('supplier_id', $request->supplier_id);

        return [
            'product_id' => $this->id,
            'sku' => $this->sku,
            'name' => $this->name,
            'supplier_stock' => $supplierStock,
        ];
    }
}
