<?php

namespace App\Http\Resources;

use App\Helpers;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ProductPricingResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        return [
            'name' => $this->name,
            'value' => Helpers::getDecimalAttribute($this->pivot->price),
            'currency' => $this->currency_code,
            'is_default' => $this->is_default,
            'info' => [
                'name' => $this->name,
                'value' => Helpers::getDecimalAttribute($this->pivot->price),
                'currency' => $this->currency_code,
            ],
        ];
    }
}
