<?php

namespace App\Http\Resources;

use App\Abstractions\Integrations\SalesChannels\ProductListingResourceInterface;
use App\DataTable\DataTableResource;
use App\Models\ProductListing;
use Illuminate\Http\Request;

/**
 * Class ProductListingResource.
 *
 * @mixin ProductListing
 */
class ProductListingResource extends DataTableResource implements ProductListingResourceInterface
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'listing_sku' => [
                'seller_sku' => $this->listing_sku,
                'id' => $this->id,
                'url' => ($this->document ? $this->document->getListingUrl() : null),
            ],
            'sales_channel_listing_id' => $this->sales_channel_listing_id,
            'title' => $this->title,
            'sales_channel' => $this->salesChannel->name,
            'integration_instance_id' => $this->salesChannel->integration_instance_id,
            'integration' => $this->salesChannel->integration->only(['id', 'name']),
            'document_id' => $this->document_id,
            'price_inherit' => empty($this->master_of_price),
            'price' => $this->price,
            'master_of_price' => $this->active_master_of_price,
            'pricing_tier_id' => $this->active_pricing_tier_id,
            'pricing_tier' => in_array(
                $this->active_master_of_price,
                [ProductListing::MASTER_SKU, ProductListing::MASTER_SALES_CHANNEL]
            ) ?
              ($this->productPricingTier->name ?? @$this->general_pricing_tier['name']) :
              null,
            'stock_inherit' => empty($this->master_of_stock),
            'quantity' => $this->quantity,
            'master_of_stock' => $this->active_master_of_stock == 'neither' ?
                ucfirst($this->active_master_of_stock) :
                $this->active_master_of_stock,
            'is_fba' => $this->is_fba,
            'sales_channel_settings' => $this->inclusive('sales_channel_settings', $this->sales_channel_settings),
            'fulfillment_latency' => $this->active_fulfillment_latency,
            'inventory_rules' => $this->inclusive('inventory_rules', $this->inventory_rules),
            'archived_at' => $this->archived_at,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
            'name' => $this->inventory_rules['name'] ?? null,
        ];
    }
}
